# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Search for minimum speed in the given limit of maximum speed $$10^7$$. Used binary search for efficiency.

# Approach
<!-- Describe your approach to solving the problem. -->
 Applying binay search : given that speed cann't exceed $$10^7$$ so searched between 1 and $$10^7$$ and find minimum speed      

At each step :
- Checked if this speed will be enough to reach on time or not
- - if not, then increase the lower limit so that I can check for higher speeds
- - if yes, then store this speed as minimum speed, but continued to search in lower half so that may be more smaller speed can satisfy
- Created function 'timetaken' to check speed 
- - function to check if at a given speed office can be reached or not
- - Math.ceil function returns value equal to or greater than a given decimal : fits best here
- - Haven't included last train distance in loop because after last train I will reach office so no need to wait - thus no round off to nearest integer ( no Math.ceil for last train)

Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)

# Complexity
- Time complexity : $$O(nlogr)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

n = length of dist[ ]
r = binary search range : $$ 1 - 10^7$$

- Space complexity : $$O(1)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public int minSpeedOnTime(int[] dist, double hour) {
        int s = -1;       
        // Applying binay search : given that speed cann't exceed 10^7 so we will search between 1 and 10^7 and find minimum speed                       
        int l = 1;
        int r = (int) 1e7;

        while( l <= r){
            int m = ( l + r)/2;
            if( timetaken( dist, m) > hour){     // check if this speed will be enough to reach on time or not
                l = m + 1;                       // if not, then increase the lower limit so that we can check for higher speeds 
            }
            else{                                // if yes, then store this speed as minimum speed, but continue to search in lower half so that may be more smaller speed can satisfy
                s = m;   
                r = m - 1;
            }
        }
        return s;
    }

    static double timetaken( int[] distances, int speed){       // function to check if at a given speed office can be reached or not
        double time = 0;
        for( int i = 0; i < distances.length - 1; i++){         // Math.ceil function returns value equal to or greater than a given decimal : fits best here
            time += Math.ceil( (double)distances[i] / speed );
        }                                                       // i haven't included last train distance in loop because after last train i will reach office so no need to wait - thus no round off to nearest integer ( no Math.ceil for last train)
        return time + (double)distances[ distances.length - 1]/speed;
    }
}
```